<?php

/*------------------------------------------------------------------------------
   $Id: password_double_opt.php,v 1.0 

   XTC-NEWSLETTER_RECIPIENTS RC1 - Contribution for XT-Commerce http://www.xt-commerce.com
   by Matthias Hinsche http://www.gamesempire.de

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce www.oscommerce.com 
   (c) 2003  nextcommerce www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

require ('includes/application_top.php');

// create smarty elements
$smarty = new Smarty;

// include boxes
if ($mobile_template == 'False') {
	require (DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/source/boxes.php');
} else {
	require (DIR_FS_CATALOG.'templates/'.CURRENT_MOBILE_TEMPLATE.'/source/boxes.php');
}
// include needed functions
require_once (DIR_FS_INC.'xtc_random_charcode.inc.php');
require_once (DIR_FS_INC.'xtc_encrypt_password.inc.php');
require_once (DIR_FS_INC.'xtc_validate_password.inc.php');
require_once (DIR_FS_INC.'xtc_rand.inc.php');
include (FILENAME_DISPLAY_VVCODES); //einbinden fr $vvimg

$case = double_opt;
$info_message = TEXT_PASSWORD_FORGOTTEN;

if (isset ($_GET['action']) && ($_GET['action'] == 'first_opt_in'))
{
	$check_customer_query = xtc_db_query("select customers_email_address, customers_id from ".TABLE_CUSTOMERS." where customers_email_address = '".xtc_db_input($_POST['email'])."'");
	$check_customer = xtc_db_fetch_array($check_customer_query);

	$vlcode = xtc_random_charcode(32);
	$link = xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, 'action=verified&customers_id='.$check_customer['customers_id'].'&key='.$vlcode, 'SSL');

	// assign language to template for caching
	$smarty->assign('language', $_SESSION['language']);
	$smarty->assign('tpl_path', 'templates/'.CURRENT_TEMPLATE.'/');
	$smarty->assign('logo_path', HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');

	// assign vars
	$smarty->assign('EMAIL', $check_customer['customers_email_address']);
	$smarty->assign('LINK', $link);
	
	$smarty->caching = false;
	require_once (DIR_FS_INC.'cseo_get_mail_body.inc.php');
	$html_mail = $smarty->fetch('html:password_verification');
	$html_mail .= $signatur_html;
	$txt_mail = $smarty->fetch('txt:password_verification');
	$txt_mail .= $signatur_text;
	require_once (DIR_FS_INC.'cseo_get_mail_data.inc.php');
	$mail_data = cseo_get_mail_data('password_verification');

	if (!empty($_POST['stringCaptcha']))
	{
		include_once('captcha_math_check.php');
		if($resultCaptcha)
		{
			if (!xtc_db_num_rows($check_customer_query))
			{
				$case = wrong_mail;
				$info_message = TEXT_EMAIL_ERROR;
			}
			else
			{
				$case = first_opt_in;
				xtc_db_query("update ".TABLE_CUSTOMERS." set password_request_key = '".$vlcode."' where customers_id = '".$check_customer['customers_id']."'");
				
				$password_verification_subject = str_replace('{$shop_name}', STORE_NAME, $mail_data['EMAIL_SUBJECT']);
				
				xtc_php_mail($mail_data['EMAIL_ADDRESS'], 
							$mail_data['EMAIL_ADDRESS_NAME'],
							$check_customer['customers_email_address'], 
							'', 
							'', 
							$mail_data['EMAIL_REPLAY_ADDRESS'], 
							$mail_data['EMAIL_REPLAY_ADDRESS_NAME'],
							'', 
							'', 
							$password_verification_subject, 
							$html_mail, 
							$txt_mail);
			}
		}
	}
	else
	{
		$case = code_error;
		$info_message = TEXT_CODE_ERROR;
	}
}

// Verification
if (isset ($_GET['action']) && ($_GET['action'] == 'verified'))
{
	$check_customer_query = xtc_db_query("select customers_id, customers_email_address, password_request_key from ".TABLE_CUSTOMERS." where customers_id = '".(int)$_GET['customers_id']."' and password_request_key = '".xtc_db_input($_GET['key'])."'");
	$check_customer = xtc_db_fetch_array($check_customer_query);
	if (!xtc_db_num_rows($check_customer_query) || $_GET['key']=="") {

		$case = no_account;
		$info_message = TEXT_NO_ACCOUNT;
	} else {

		$newpass = xtc_create_random_value(ENTRY_PASSWORD_MIN_LENGTH);
		$crypted_password = xtc_encrypt_password($newpass);

		xtc_db_query("update ".TABLE_CUSTOMERS." set customers_password = '".$crypted_password."' where customers_email_address = '".xtc_db_input($check_customer['customers_email_address'])."'");
		xtc_db_query("update ".TABLE_CUSTOMERS." set password_request_key = '' where customers_id = '".$check_customer['customers_id']."'");
		// assign language to template for caching
		$smarty->assign('language', $_SESSION['language']);
		$smarty->assign('tpl_path', 'templates/'.CURRENT_TEMPLATE.'/');
		$smarty->assign('logo_path', HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');

		// assign vars
		$smarty->assign('EMAIL', $check_customer['customers_email_address']);
		$smarty->assign('NEW_PASSWORD', $newpass);
				
		$smarty->caching = false;
		require_once (DIR_FS_INC.'cseo_get_mail_body.inc.php');
		$html_mail = $smarty->fetch('html:new_password');
		$html_mail .= $signatur_html;
		$txt_mail = $smarty->fetch('txt:new_password');
		$txt_mail .= $signatur_text;
		require_once (DIR_FS_INC.'cseo_get_mail_data.inc.php');
		$mail_data = cseo_get_mail_data('new_password');
		
		$new_password_subject = str_replace('{$shop_name}', STORE_NAME, $mail_data['EMAIL_SUBJECT']);
		
		xtc_php_mail($mail_data['EMAIL_ADDRESS'], 
					$mail_data['EMAIL_ADDRESS_NAME'], 
					$check_customer['customers_email_address'], 
					'', 
					'', 
					$mail_data['EMAIL_REPLAY_ADDRESS'], 
					$mail_data['EMAIL_REPLAY_ADDRESS_NAME'], 
					'', 
					'', 
					$new_password_subject, 
					$html_mail, 
					$txt_mail);
		if (!isset ($mail_error)) {
			$_SESSION['info_message'] = urlencode(TEXT_PASSWORD_SENT);
			xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL', true, false));
		}
	}
}

$breadcrumb->add(NAVBAR_TITLE_PASSWORD_DOUBLE_OPT, xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, '', 'SSL'));

require (DIR_WS_INCLUDES.'header.php');


switch ($case) {
	case first_opt_in :
		$smarty->assign('text_heading', HEADING_PASSWORD_FORGOTTEN);
		$smarty->assign('info_message', $info_message);
		$smarty->assign('info_message', TEXT_LINK_MAIL_SENDED);
		$smarty->assign('language', $_SESSION['language']);
		$smarty->caching = 0;
		if ($mobile_template == 'False') {
			$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/password_messages.html');
		} else {
			$main_content = $smarty->fetch(CURRENT_MOBILE_TEMPLATE.'/module/password_messages.html');
		}
		break;

	case second_opt_in :
		$smarty->assign('text_heading', HEADING_PASSWORD_FORGOTTEN);
		$smarty->assign('info_message', $info_message);
		//    $smarty->assign('info_message', TEXT_PASSWORD_MAIL_SENDED);
		$smarty->assign('language', $_SESSION['language']);
		$smarty->caching = 0;
		if ($mobile_template == 'False') {
			$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/password_messages.html');
		} else {
			$main_content = $smarty->fetch(CURRENT_MOBILE_TEMPLATE.'/module/password_messages.html');
		}
		break;

	case code_error :

		$smarty->assign('VVIMG', '<img src="'.$vvimg.'" alt="Security Image 1" />');
		$smarty->assign('text_heading', HEADING_PASSWORD_FORGOTTEN);
		$smarty->assign('info_message', $info_message);
		$smarty->assign('message', TEXT_PASSWORD_FORGOTTEN);
		$smarty->assign('SHOP_NAME', STORE_NAME);
		$smarty->assign('FORM_ACTION', xtc_draw_form('sign', xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, 'action=first_opt_in', 'SSL')));
		$smarty->assign('INPUT_EMAIL', xtc_draw_input_field('email', xtc_db_input($_POST['email'])));
		$smarty->assign('INPUT_CODE', xtc_draw_input_field('stringCaptcha', '', 'size="6" maxlength="6"', false, '', false));
		$smarty->assign("codeCaptcha", xtc_draw_hidden_field("codeCaptcha", $_SESSION['vvcode'], ""));
		
		$smarty->assign('BUTTON_SEND', xtc_image_submit('button_send.gif', IMAGE_BUTTON_CONTINUE));
		$smarty->assign('language', $_SESSION['language']);
		$smarty->caching = 0;
		if ($mobile_template == 'False') {
			$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/password_double_opt_in.html');
		} else {
			$main_content = $smarty->fetch(CURRENT_MOBILE_TEMPLATE.'/module/password_double_opt_in.html');
		}
		break;

	case wrong_mail :
	
		$smarty->assign('VVIMG', '<img src="'.$vvimg.'" alt="Security Image 2">');
		$smarty->assign('text_heading', HEADING_PASSWORD_FORGOTTEN);
		$smarty->assign('info_message', $info_message);
		$smarty->assign('message', TEXT_PASSWORD_FORGOTTEN);
		$smarty->assign('SHOP_NAME', STORE_NAME);
		$smarty->assign('FORM_ACTION', xtc_draw_form('sign', xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, 'action=first_opt_in', 'SSL')));
		$smarty->assign('INPUT_EMAIL', xtc_draw_input_field('email', xtc_db_input($_POST['email'])));
		$smarty->assign('INPUT_CODE', xtc_draw_input_field('stringCaptcha', '', 'size="6" maxlength="6"', false, '', false));
		$smarty->assign("codeCaptcha", xtc_draw_hidden_field("codeCaptcha", $_SESSION['vvcode'], ""));
		
		$smarty->assign('BUTTON_SEND', xtc_image_submit('button_send.gif', IMAGE_BUTTON_CONTINUE));
		$smarty->assign('language', $_SESSION['language']);
		$smarty->caching = 0;
		if ($mobile_template == 'False') {
			$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/password_double_opt_in.html');
		} else {
			$main_content = $smarty->fetch(CURRENT_MOBILE_TEMPLATE.'/module/password_double_opt_in.html');
		}
		break;

	case no_account :
		$smarty->assign('text_heading', HEADING_PASSWORD_FORGOTTEN);
		$smarty->assign('info_message', $info_message);
		$smarty->assign('language', $_SESSION['language']);
		$smarty->caching = 0;
		if ($mobile_template == 'False') {
			$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/password_messages.html');
		} else {
			$main_content = $smarty->fetch(CURRENT_MOBILE_TEMPLATE.'/module/password_messages.html');
		}		
		
		break;
		
	case double_opt :
		$smarty->assign('VVIMG', '<img src="'.$vvimg.'" alt="Security Image 3">');
		$smarty->assign('text_heading', HEADING_PASSWORD_FORGOTTEN);
		//    $smarty->assign('info_message', $info_message);
		$smarty->assign('message', TEXT_PASSWORD_FORGOTTEN);
		$smarty->assign('SHOP_NAME', STORE_NAME);
		$smarty->assign('FORM_ACTION', xtc_draw_form('sign', xtc_href_link(FILENAME_PASSWORD_DOUBLE_OPT, 'action=first_opt_in', 'SSL')));
		$smarty->assign('INPUT_EMAIL', xtc_draw_input_field('email', xtc_db_input($_POST['email'])));
		$smarty->assign('INPUT_CODE', xtc_draw_input_field('stringCaptcha', '', 'size="6" maxlength="6"', false, '', false));
		$smarty->assign("codeCaptcha", xtc_draw_hidden_field("codeCaptcha", $_SESSION['vvcode'], ""));
		
		$smarty->assign('BUTTON_SEND', xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE));
		$smarty->assign('FORM_END', '</form>');
		$smarty->assign('language', $_SESSION['language']);
		$smarty->caching = 0;
		if ($mobile_template == 'False') {
			$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/password_double_opt_in.html');
		} else {
			$main_content = $smarty->fetch(CURRENT_MOBILE_TEMPLATE.'/module/password_double_opt_in.html');
		}	
		break;
}

$smarty->assign('main_content', $main_content);
$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
if (!defined(RM))
	$smarty->load_filter('output', 'note');
if ($mobile_template == 'False') {
	$smarty->display(CURRENT_TEMPLATE.'/index.html');
} else {
	$smarty->display(CURRENT_MOBILE_TEMPLATE.'/index.html');
}	
include ('includes/application_bottom.php');
?>